"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "notification_type"


async def describe_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Describes the notification types that are supported by Amazon EC2 Auto Scaling.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.auto_scaling.notification_type_.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.auto_scaling.notification_type.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="describe_auto_scaling_notification_types",
        op_kwargs={},
    )
