"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub, ctx, instance_ids: List = None, max_records: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the Auto Scaling instances in the account and Region.

    Args:
        instance_ids(List, optional): The IDs of the instances. If you omit this parameter, all Auto Scaling instances are described. If you specify an ID that does not exist, it is ignored with no error. Array Members: Maximum number of 50 items. Defaults to None.
        max_records(int, optional): The maximum number of items to return with this call. The default value is 50 and the maximum value is 50. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.auto_scaling.instance.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.auto_scaling.instance.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="describe_auto_scaling_instances",
        op_kwargs={
            "InstanceIds": instance_ids,
            "MaxRecords": max_records,
            "NextToken": next_token,
        },
    )
