"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    auto_scaling_group_name: str,
    min_size: int,
    max_size: int,
    launch_configuration_name: str = None,
    launch_template: Dict = None,
    mixed_instances_policy: Dict = None,
    instance_id: str = None,
    desired_capacity: int = None,
    default_cooldown: int = None,
    availability_zones: List = None,
    load_balancer_names: List = None,
    target_group_ar_ns: List = None,
    health_check_type: str = None,
    health_check_grace_period: int = None,
    placement_group: str = None,
    vpc_zone_identifier: str = None,
    termination_policies: List = None,
    new_instances_protected_from_scale_in: bool = None,
    capacity_rebalance: bool = None,
    lifecycle_hook_specification_list: List = None,
    tags: List = None,
    service_linked_role_arn: str = None,
    max_instance_lifetime: int = None,
    context: str = None,
) -> None:
    r"""
    **Autogenerated function**

     We strongly recommend using a launch template when calling this operation to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2.  Creates an Auto Scaling group with the specified name and attributes.  If you exceed your maximum limit of Auto Scaling groups, the call fails. To query this limit, call the DescribeAccountLimits API. For information about updating this limit, see Amazon EC2 Auto Scaling service quotas in the Amazon EC2 Auto Scaling User Guide. For introductory exercises for creating an Auto Scaling group, see Getting started with Amazon EC2 Auto Scaling and Tutorial: Set up a scaled and load-balanced application in the Amazon EC2 Auto Scaling User Guide. For more information, see Auto Scaling groups in the Amazon EC2 Auto Scaling User Guide. Every Auto Scaling group has three size parameters (DesiredCapacity, MaxSize, and MinSize). Usually, you set these sizes based on a specific number of instances. However, if you configure a mixed instances policy that defines weights for the instance types, you must specify these sizes with the same units that you use for weighting instances.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group. This name must be unique per Region per account.
        launch_configuration_name(str, optional): The name of the launch configuration to use to launch instances.  Conditional: You must specify either a launch template (LaunchTemplate or MixedInstancesPolicy) or a launch configuration (LaunchConfigurationName or InstanceId). Defaults to None.
        launch_template(Dict, optional): Parameters used to specify the launch template and version to use to launch instances.  Conditional: You must specify either a launch template (LaunchTemplate or MixedInstancesPolicy) or a launch configuration (LaunchConfigurationName or InstanceId).  The launch template that is specified must be configured for use with an Auto Scaling group. For more information, see Creating a launch template for an Auto Scaling group in the Amazon EC2 Auto Scaling User Guide. . Defaults to None.
        mixed_instances_policy(Dict, optional): An embedded object that specifies a mixed instances policy. The required properties must be specified. If optional properties are unspecified, their default values are used. The policy includes properties that not only define the distribution of On-Demand Instances and Spot Instances, the maximum price to pay for Spot Instances, and how the Auto Scaling group allocates instance types to fulfill On-Demand and Spot capacities, but also the properties that specify the instance configuration information—the launch template and instance types. The policy can also include a weight for each instance type and different launch templates for individual instance types. For more information, see Auto Scaling groups with multiple instance types and purchase options in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        instance_id(str, optional): The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto Scaling uses the configuration values from the specified instance to create a new launch configuration. To get the instance ID, use the Amazon EC2 DescribeInstances API operation. For more information, see Creating an Auto Scaling group using an EC2 instance in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        min_size(int): The minimum size of the group.
        max_size(int): The maximum size of the group.  With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above MaxSize to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above MaxSize by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group). .
        desired_capacity(int, optional): The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the capacity it attempts to maintain. It can scale beyond this capacity if you configure auto scaling. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group. If you do not specify a desired capacity, the default is the minimum size of the group. Defaults to None.
        default_cooldown(int, optional): The amount of time, in seconds, after a scaling activity completes before another scaling activity can start. The default value is 300. This setting applies when using simple scaling policies, but not when using other scaling policies or scheduled scaling. For more information, see Scaling cooldowns for Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        availability_zones(List, optional): A list of Availability Zones where instances in the Auto Scaling group can be created. This parameter is optional if you specify one or more subnets for VPCZoneIdentifier. Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances into EC2-Classic. Defaults to None.
        load_balancer_names(List, optional): A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers, Network Load Balancers, and Gateway Load Balancers, specify the TargetGroupARNs property instead. Defaults to None.
        target_group_ar_ns(List, optional): The Amazon Resource Names (ARN) of the target groups to associate with the Auto Scaling group. Instances are registered as targets in a target group, and traffic is routed to the target group. For more information, see Elastic Load Balancing and Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        health_check_type(str, optional): The service to use for the health checks. The valid values are EC2 (default) and ELB. If you configure an Auto Scaling group to use load balancer (ELB) health checks, it considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks. For more information, see Health checks for Auto Scaling instances in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        health_check_grace_period(int, optional): The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service. During this time, any health check failures for the instance are ignored. The default value is 0. For more information, see Health check grace period in the Amazon EC2 Auto Scaling User Guide. Conditional: Required if you are adding an ELB health check. Defaults to None.
        placement_group(str, optional): The name of an existing placement group into which to launch your instances, if any. A placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a placement group. For more information, see Placement Groups in the Amazon EC2 User Guide for Linux Instances. Defaults to None.
        vpc_zone_identifier(str, optional): A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group can be created. If you specify VPCZoneIdentifier with AvailabilityZones, the subnets that you specify for this parameter must reside in those Availability Zones. Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances into a VPC. Defaults to None.
        termination_policies(List, optional): A policy or a list of policies that are used to select the instance to terminate. These policies are executed in the order that you list them. For more information, see Controlling which Auto Scaling instances terminate during scale in in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        new_instances_protected_from_scale_in(bool, optional): Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see Instance scale-in protection in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        capacity_rebalance(bool, optional): Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then terminates an old instance. For more information, see Amazon EC2 Auto Scaling Capacity Rebalancing in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        lifecycle_hook_specification_list(List, optional): One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto Scaling launches or terminates instances. Defaults to None.
        tags(List, optional): One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags in a launch template but use caution. If the launch template specifies an instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag with the value specified by the Auto Scaling group. For more information, see Tagging Auto Scaling groups and instances in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        service_linked_role_arn(str, optional): The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named AWSServiceRoleForAutoScaling, which it creates if it does not exist. For more information, see Service-linked roles in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        max_instance_lifetime(int, optional): The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see Replacing Auto Scaling instances based on maximum instance lifetime in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        context(str, optional): Reserved. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.auto_scaling.group.create(
                ctx, auto_scaling_group_name=value, min_size=value, max_size=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.auto_scaling.group.create auto_scaling_group_name=value, min_size=value, max_size=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="create_auto_scaling_group",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "LaunchConfigurationName": launch_configuration_name,
            "LaunchTemplate": launch_template,
            "MixedInstancesPolicy": mixed_instances_policy,
            "InstanceId": instance_id,
            "MinSize": min_size,
            "MaxSize": max_size,
            "DesiredCapacity": desired_capacity,
            "DefaultCooldown": default_cooldown,
            "AvailabilityZones": availability_zones,
            "LoadBalancerNames": load_balancer_names,
            "TargetGroupARNs": target_group_ar_ns,
            "HealthCheckType": health_check_type,
            "HealthCheckGracePeriod": health_check_grace_period,
            "PlacementGroup": placement_group,
            "VPCZoneIdentifier": vpc_zone_identifier,
            "TerminationPolicies": termination_policies,
            "NewInstancesProtectedFromScaleIn": new_instances_protected_from_scale_in,
            "CapacityRebalance": capacity_rebalance,
            "LifecycleHookSpecificationList": lifecycle_hook_specification_list,
            "Tags": tags,
            "ServiceLinkedRoleARN": service_linked_role_arn,
            "MaxInstanceLifetime": max_instance_lifetime,
            "Context": context,
        },
    )


async def delete(
    hub, ctx, auto_scaling_group_name: str, force_delete: bool = None
) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified Auto Scaling group. If the group has instances or scaling activities in progress, you must specify the option to force the deletion in order for it to succeed. If the group has policies, deleting the group deletes the policies, the underlying alarm actions, and any alarm that no longer has an associated action. To remove instances from the Auto Scaling group before deleting it, call the DetachInstances API with the list of instances and the option to decrement the desired capacity. This ensures that Amazon EC2 Auto Scaling does not launch replacement instances. To terminate all instances before deleting the Auto Scaling group, call the UpdateAutoScalingGroup API and set the minimum size and desired capacity of the Auto Scaling group to zero.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        force_delete(bool, optional): Specifies that the group is to be deleted along with all instances associated with the group, without waiting for all instances to be terminated. This parameter also deletes any outstanding lifecycle actions associated with the group. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.auto_scaling.group.delete(
                ctx, auto_scaling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.auto_scaling.group.delete auto_scaling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="delete_auto_scaling_group",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "ForceDelete": force_delete,
        },
    )


async def describe_all(
    hub,
    ctx,
    auto_scaling_group_names: List = None,
    next_token: str = None,
    max_records: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the Auto Scaling groups in the account and Region. This operation returns information about instances in Auto Scaling groups. To retrieve information about the instances in a warm pool, you must call the DescribeWarmPool API.

    Args:
        auto_scaling_group_names(List, optional): The names of the Auto Scaling groups. By default, you can only specify up to 50 names. You can optionally increase this limit using the MaxRecords parameter. If you omit this parameter, all Auto Scaling groups are described. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        max_records(int, optional): The maximum number of items to return with this call. The default value is 50 and the maximum value is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.auto_scaling.group.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.auto_scaling.group.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="describe_auto_scaling_groups",
        op_kwargs={
            "AutoScalingGroupNames": auto_scaling_group_names,
            "NextToken": next_token,
            "MaxRecords": max_records,
        },
    )


async def update(
    hub,
    ctx,
    auto_scaling_group_name: str,
    launch_configuration_name: str = None,
    launch_template: Dict = None,
    mixed_instances_policy: Dict = None,
    min_size: int = None,
    max_size: int = None,
    desired_capacity: int = None,
    default_cooldown: int = None,
    availability_zones: List = None,
    health_check_type: str = None,
    health_check_grace_period: int = None,
    placement_group: str = None,
    vpc_zone_identifier: str = None,
    termination_policies: List = None,
    new_instances_protected_from_scale_in: bool = None,
    service_linked_role_arn: str = None,
    max_instance_lifetime: int = None,
    capacity_rebalance: bool = None,
    context: str = None,
) -> None:
    r"""
    **Autogenerated function**

     We strongly recommend that all Auto Scaling groups use launch templates to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2.  Updates the configuration for the specified Auto Scaling group. To update an Auto Scaling group, specify the name of the group and the parameter that you want to change. Any parameters that you don't specify are not changed by this update request. The new settings take effect on any scaling activities after this call returns.  If you associate a new launch configuration or template with an Auto Scaling group, all new instances will get the updated configuration. Existing instances continue to run with the configuration that they were originally launched with. When you update a group to specify a mixed instances policy instead of a launch configuration or template, existing instances may be replaced to match the new purchasing options that you specified in the policy. For example, if the group currently has 100% On-Demand capacity and the policy specifies 50% Spot capacity, this means that half of your instances will be gradually terminated and relaunched as Spot Instances. When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the old ones, so that updating your group does not compromise the performance or availability of your application. Note the following about changing DesiredCapacity, MaxSize, or MinSize:   If a scale-in activity occurs as a result of a new DesiredCapacity value that is lower than the current size of the group, the Auto Scaling group uses its termination policy to determine which instances to terminate.   If you specify a new value for MinSize without specifying a value for DesiredCapacity, and the new MinSize is larger than the current size of the group, this sets the group's DesiredCapacity to the new MinSize value.   If you specify a new value for MaxSize without specifying a value for DesiredCapacity, and the new MaxSize is smaller than the current size of the group, this sets the group's DesiredCapacity to the new MaxSize value.   To see which parameters have been set, call the DescribeAutoScalingGroups API. To view the scaling policies for an Auto Scaling group, call the DescribePolicies API. If the group has scaling policies, you can update them by calling the PutScalingPolicy API.

    Args:
        auto_scaling_group_name(str): The name of the Auto Scaling group.
        launch_configuration_name(str, optional): The name of the launch configuration. If you specify LaunchConfigurationName in your update request, you can't specify LaunchTemplate or MixedInstancesPolicy. Defaults to None.
        launch_template(Dict, optional): The launch template and version to use to specify the updates. If you specify LaunchTemplate in your update request, you can't specify LaunchConfigurationName or MixedInstancesPolicy. Defaults to None.
        mixed_instances_policy(Dict, optional): An embedded object that specifies a mixed instances policy. When you make changes to an existing policy, all optional properties are left unchanged if not specified. For more information, see Auto Scaling groups with multiple instance types and purchase options in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        min_size(int, optional): The minimum size of the Auto Scaling group. Defaults to None.
        max_size(int, optional): The maximum size of the Auto Scaling group.  With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above MaxSize to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above MaxSize by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group). . Defaults to None.
        desired_capacity(int, optional): The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the capacity it attempts to maintain. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group. Defaults to None.
        default_cooldown(int, optional): The amount of time, in seconds, after a scaling activity completes before another scaling activity can start. The default value is 300. This setting applies when using simple scaling policies, but not when using other scaling policies or scheduled scaling. For more information, see Scaling cooldowns for Amazon EC2 Auto Scaling in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        availability_zones(List, optional): One or more Availability Zones for the group. Defaults to None.
        health_check_type(str, optional): The service to use for the health checks. The valid values are EC2 and ELB. If you configure an Auto Scaling group to use ELB health checks, it considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks. Defaults to None.
        health_check_grace_period(int, optional): The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service. The default value is 0. For more information, see Health check grace period in the Amazon EC2 Auto Scaling User Guide. Conditional: Required if you are adding an ELB health check. Defaults to None.
        placement_group(str, optional): The name of an existing placement group into which to launch your instances, if any. A placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a placement group. For more information, see Placement Groups in the Amazon EC2 User Guide for Linux Instances. Defaults to None.
        vpc_zone_identifier(str, optional): A comma-separated list of subnet IDs for a virtual private cloud (VPC). If you specify VPCZoneIdentifier with AvailabilityZones, the subnets that you specify for this parameter must reside in those Availability Zones. Defaults to None.
        termination_policies(List, optional): A policy or a list of policies that are used to select the instances to terminate. The policies are executed in the order that you list them. For more information, see Controlling which Auto Scaling instances terminate during scale in in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        new_instances_protected_from_scale_in(bool, optional): Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see Instance scale-in protection in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        service_linked_role_arn(str, optional): The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf. For more information, see Service-linked roles in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        max_instance_lifetime(int, optional): The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). To clear a previously set value, specify a new value of 0. For more information, see Replacing Auto Scaling instances based on maximum instance lifetime in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        capacity_rebalance(bool, optional): Enables or disables Capacity Rebalancing. For more information, see Amazon EC2 Auto Scaling Capacity Rebalancing in the Amazon EC2 Auto Scaling User Guide. Defaults to None.
        context(str, optional): Reserved. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.autoscaling.auto_scaling.group.update(
                ctx, auto_scaling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.autoscaling.auto_scaling.group.update auto_scaling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="autoscaling",
        operation="update_auto_scaling_group",
        op_kwargs={
            "AutoScalingGroupName": auto_scaling_group_name,
            "LaunchConfigurationName": launch_configuration_name,
            "LaunchTemplate": launch_template,
            "MixedInstancesPolicy": mixed_instances_policy,
            "MinSize": min_size,
            "MaxSize": max_size,
            "DesiredCapacity": desired_capacity,
            "DefaultCooldown": default_cooldown,
            "AvailabilityZones": availability_zones,
            "HealthCheckType": health_check_type,
            "HealthCheckGracePeriod": health_check_grace_period,
            "PlacementGroup": placement_group,
            "VPCZoneIdentifier": vpc_zone_identifier,
            "TerminationPolicies": termination_policies,
            "NewInstancesProtectedFromScaleIn": new_instances_protected_from_scale_in,
            "ServiceLinkedRoleARN": service_linked_role_arn,
            "MaxInstanceLifetime": max_instance_lifetime,
            "CapacityRebalance": capacity_rebalance,
            "Context": context,
        },
    )
