"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(hub, ctx, attribute: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns the settings for the specified account.

    Args:
        attribute(str):  The list of SettingAttribute enum values. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.setting.get_all(ctx, attribute=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.setting.get_all attribute=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="get_settings",
        op_kwargs={"attribute": attribute},
    )


async def update_multiple(
    hub,
    ctx,
    sns_topic: str = None,
    default_assessment_reports_destination: Dict = None,
    default_process_owners: List = None,
    kms_key: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Updates Audit Manager settings for the current user account.

    Args:
        sns_topic(str, optional):  The Amazon Simple Notification Service (Amazon SNS) topic to which Audit Manager sends notifications. . Defaults to None.
        default_assessment_reports_destination(Dict, optional):  The default storage destination for assessment reports. . Defaults to None.
        default_process_owners(List, optional):  A list of the default audit owners. . Defaults to None.
        kms_key(str, optional):  The KMS key details. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.setting.update_multiple(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.setting.update_multiple
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="update_settings",
        op_kwargs={
            "snsTopic": sns_topic,
            "defaultAssessmentReportsDestination": default_assessment_reports_destination,
            "defaultProcessOwners": default_process_owners,
            "kmsKey": kms_key,
        },
    )
