"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def deregister(hub, ctx, admin_account_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified member account as a delegated administrator for Audit Manager.   When you remove a delegated administrator from your Audit Manager settings, or when you deregister a delegated administrator from Organizations, you continue to have access to the evidence that you previously collected under that account. However, Audit Manager will stop collecting and attaching evidence to that delegated administrator account moving forward.

    Args:
        admin_account_id(str, optional):  The identifier for the specified administrator account. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.organization_admin_account.deregister(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.organization_admin_account.deregister
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="deregister_organization_admin_account",
        op_kwargs={"adminAccountId": admin_account_id},
    )


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

     Returns the name of the delegated Amazon Web Services administrator account for the organization.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.organization_admin_account.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.organization_admin_account.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="get_organization_admin_account",
        op_kwargs={},
    )


async def register(hub, ctx, admin_account_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Enables an account within the organization as the delegated administrator for Audit Manager.

    Args:
        admin_account_id(str):  The identifier for the specified delegated administrator account. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.organization_admin_account.register(
                ctx, admin_account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.organization_admin_account.register admin_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="register_organization_admin_account",
        op_kwargs={"adminAccountId": admin_account_id},
    )
