"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of all Audit Manager notifications.

    Args:
        next_token(str, optional):  The pagination token used to fetch the next set of results. . Defaults to None.
        max_results(int, optional):  Represents the maximum number of results per page, or per API request call. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.notification.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.notification.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="list_notifications",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )
