"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, source: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of keywords that pre-mapped to the specified control data source.

    Args:
        source(str):  The control mapping data source to which the keywords apply. .
        next_token(str, optional):  The pagination token used to fetch the next set of results. . Defaults to None.
        max_results(int, optional):  Represents the maximum number of results per page, or per API request call. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.keyword_for_data_source.list(ctx, source=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.keyword_for_data_source.list source=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="list_keywords_for_data_source",
        op_kwargs={
            "source": source,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
