"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    assessment_id: str,
    control_set_id: str,
    evidence_folder_id: str,
    evidence_id: str,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns evidence from Audit Manager.

    Args:
        assessment_id(str):  The identifier for the specified assessment. .
        control_set_id(str):  The identifier for the specified control set. .
        evidence_folder_id(str):  The identifier for the folder in which the evidence is stored. .
        evidence_id(str):  The identifier for the evidence. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.evidence.init.get(
                ctx,
                assessment_id=value,
                control_set_id=value,
                evidence_folder_id=value,
                evidence_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.evidence.init.get assessment_id=value, control_set_id=value, evidence_folder_id=value, evidence_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="get_evidence",
        op_kwargs={
            "assessmentId": assessment_id,
            "controlSetId": control_set_id,
            "evidenceFolderId": evidence_folder_id,
            "evidenceId": evidence_id,
        },
    )
