"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, assessment_id: str, control_set_id: str, evidence_folder_id: str
) -> Dict:
    r"""
    **Autogenerated function**

     Returns an evidence folder from the specified assessment in Audit Manager.

    Args:
        assessment_id(str):  The identifier for the specified assessment. .
        control_set_id(str):  The identifier for the specified control set. .
        evidence_folder_id(str):  The identifier for the folder in which the evidence is stored. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.evidence.folder.init.get(
                ctx, assessment_id=value, control_set_id=value, evidence_folder_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.evidence.folder.init.get assessment_id=value, control_set_id=value, evidence_folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="get_evidence_folder",
        op_kwargs={
            "assessmentId": assessment_id,
            "controlSetId": control_set_id,
            "evidenceFolderId": evidence_folder_id,
        },
    )
