"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, assessment_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

     Returns the evidence folders from a specified assessment in Audit Manager.

    Args:
        assessment_id(str):  The identifier for the specified assessment. .
        next_token(str, optional):  The pagination token used to fetch the next set of results. . Defaults to None.
        max_results(int, optional):  Represents the maximum number of results per page, or per API request call. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.evidence.folder.by_assessment.init.get(
                ctx, assessment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.evidence.folder.by_assessment.init.get assessment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="get_evidence_folders_by_assessment",
        op_kwargs={
            "assessmentId": assessment_id,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
