"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, delegation_ids: List, assessment_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes the delegations in the specified Audit Manager assessment.

    Args:
        delegation_ids(List):  The identifiers for the specified delegations. .
        assessment_id(str):  The identifier for the specified assessment. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.delete_delegation_by_assessment.batch(
                ctx, delegation_ids=value, assessment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.delete_delegation_by_assessment.batch delegation_ids=value, assessment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="batch_delete_delegation_by_assessment",
        op_kwargs={"delegationIds": delegation_ids, "assessmentId": assessment_id},
    )
