"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, create_delegation_requests: List, assessment_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Create a batch of delegations for a specified assessment in Audit Manager.

    Args:
        create_delegation_requests(List):  The API request to batch create delegations in Audit Manager. .
        assessment_id(str):  The identifier for the specified assessment. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.create_delegation_by_assessment.batch(
                ctx, create_delegation_requests=value, assessment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.create_delegation_by_assessment.batch create_delegation_requests=value, assessment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="batch_create_delegation_by_assessment",
        op_kwargs={
            "createDelegationRequests": create_delegation_requests,
            "assessmentId": assessment_id,
        },
    )
