"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    control_mapping_sources: List,
    description: str = None,
    testing_information: str = None,
    action_plan_title: str = None,
    action_plan_instructions: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a new custom control in Audit Manager.

    Args:
        name(str):  The name of the control. .
        description(str, optional):  The description of the control. . Defaults to None.
        testing_information(str, optional):  The steps to follow to determine if the control has been satisfied. . Defaults to None.
        action_plan_title(str, optional):  The title of the action plan for remediating the control. . Defaults to None.
        action_plan_instructions(str, optional):  The recommended actions to carry out if the control is not fulfilled. . Defaults to None.
        control_mapping_sources(List):  The data mapping sources for the specified control. .
        tags(Dict, optional):  The tags associated with the control. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.control.create(
                ctx, name=value, control_mapping_sources=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.control.create name=value, control_mapping_sources=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="create_control",
        op_kwargs={
            "name": name,
            "description": description,
            "testingInformation": testing_information,
            "actionPlanTitle": action_plan_title,
            "actionPlanInstructions": action_plan_instructions,
            "controlMappingSources": control_mapping_sources,
            "tags": tags,
        },
    )


async def delete(hub, ctx, control_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a custom control in Audit Manager.

    Args:
        control_id(str):  The identifier for the specified control. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.control.delete(ctx, control_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.control.delete control_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="delete_control",
        op_kwargs={"controlId": control_id},
    )


async def get(hub, ctx, control_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns a control from Audit Manager.

    Args:
        control_id(str):  The identifier for the specified control. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.control.get(ctx, control_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.control.get control_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="get_control",
        op_kwargs={"controlId": control_id},
    )


async def list_all(
    hub, ctx, control_type: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of controls from Audit Manager.

    Args:
        control_type(str):  The type of control, such as standard or custom. .
        next_token(str, optional):  The pagination token used to fetch the next set of results. . Defaults to None.
        max_results(int, optional):  Represents the maximum number of results per page, or per API request call. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.control.list_all(ctx, control_type=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.control.list_all control_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="list_controls",
        op_kwargs={
            "controlType": control_type,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    control_id: str,
    name: str,
    control_mapping_sources: List,
    description: str = None,
    testing_information: str = None,
    action_plan_title: str = None,
    action_plan_instructions: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Updates a custom control in Audit Manager.

    Args:
        control_id(str):  The identifier for the specified control. .
        name(str):  The name of the control to be updated. .
        description(str, optional):  The optional description of the control. . Defaults to None.
        testing_information(str, optional):  The steps that to follow to determine if the control has been satisfied. . Defaults to None.
        action_plan_title(str, optional):  The title of the action plan for remediating the control. . Defaults to None.
        action_plan_instructions(str, optional):  The recommended actions to carry out if the control is not fulfilled. . Defaults to None.
        control_mapping_sources(List):  The data mapping sources for the specified control. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.control.update(
                ctx, control_id=value, name=value, control_mapping_sources=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.control.update control_id=value, name=value, control_mapping_sources=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="update_control",
        op_kwargs={
            "controlId": control_id,
            "name": name,
            "description": description,
            "testingInformation": testing_information,
            "actionPlanTitle": action_plan_title,
            "actionPlanInstructions": action_plan_instructions,
            "controlMappingSources": control_mapping_sources,
        },
    )
