"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub, ctx, assessment_id: str, evidence_folder_id: str, evidence_ids: List
) -> Dict:
    r"""
    **Autogenerated function**

     Associates a list of evidence to an assessment report in an Audit Manager assessment.

    Args:
        assessment_id(str):  The unique identifier for the specified assessment. .
        evidence_folder_id(str):  The identifier for the folder in which the evidence is stored. .
        evidence_ids(List):  The list of evidence identifiers. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.associate_assessment_report_evidence.batch(
                ctx, assessment_id=value, evidence_folder_id=value, evidence_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.associate_assessment_report_evidence.batch assessment_id=value, evidence_folder_id=value, evidence_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="batch_associate_assessment_report_evidence",
        op_kwargs={
            "assessmentId": assessment_id,
            "evidenceFolderId": evidence_folder_id,
            "evidenceIds": evidence_ids,
        },
    )
