"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, assessment_id: str, status: str) -> Dict:
    r"""
    **Autogenerated function**

     Updates the status of an assessment in Audit Manager.

    Args:
        assessment_id(str):  The identifier for the specified assessment. .
        status(str):  The current status of the specified assessment. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.assessment.status.update(
                ctx, assessment_id=value, status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.assessment.status.update assessment_id=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="update_assessment_status",
        op_kwargs={"assessmentId": assessment_id, "status": status},
    )
