"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def validate(hub, ctx, s3_relative_path: str) -> Dict:
    r"""
    **Autogenerated function**

     Validates the integrity of an assessment report in Audit Manager.

    Args:
        s3_relative_path(str):  The relative path of the specified Amazon S3 bucket in which the assessment report is stored. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.assessment.report.integrity.validate(
                ctx, s3_relative_path=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.assessment.report.integrity.validate s3_relative_path=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="validate_assessment_report_integrity",
        op_kwargs={"s3RelativePath": s3_relative_path},
    )
