"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, name: str, assessment_id: str, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Creates an assessment report for the specified assessment.

    Args:
        name(str):  The name of the new assessment report. .
        description(str, optional):  The description of the assessment report. . Defaults to None.
        assessment_id(str):  The identifier for the specified assessment. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.assessment.report.init.create(
                ctx, name=value, assessment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.assessment.report.init.create name=value, assessment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="create_assessment_report",
        op_kwargs={
            "name": name,
            "description": description,
            "assessmentId": assessment_id,
        },
    )


async def delete(hub, ctx, assessment_id: str, assessment_report_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes an assessment report from an assessment in Audit Manager.

    Args:
        assessment_id(str):  The identifier for the specified assessment. .
        assessment_report_id(str):  The unique identifier for the assessment report. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.assessment.report.init.delete(
                ctx, assessment_id=value, assessment_report_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.assessment.report.init.delete assessment_id=value, assessment_report_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="delete_assessment_report",
        op_kwargs={
            "assessmentId": assessment_id,
            "assessmentReportId": assessment_report_id,
        },
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of assessment reports created in Audit Manager.

    Args:
        next_token(str, optional):  The pagination token used to fetch the next set of results. . Defaults to None.
        max_results(int, optional):  Represents the maximum number of results per page, or per API request call. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.assessment.report.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.assessment.report.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="list_assessment_reports",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )
