"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, assessment_id: str, evidence_folder_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Associates an evidence folder to the specified assessment report in Audit Manager.

    Args:
        assessment_id(str):  The identifier for the specified assessment. .
        evidence_folder_id(str):  The identifier for the folder in which evidence is stored. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.assessment.report.evidence_folder.associate(
                ctx, assessment_id=value, evidence_folder_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.assessment.report.evidence_folder.associate assessment_id=value, evidence_folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="associate_assessment_report_evidence_folder",
        op_kwargs={
            "assessmentId": assessment_id,
            "evidenceFolderId": evidence_folder_id,
        },
    )


async def disassociate(hub, ctx, assessment_id: str, evidence_folder_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Disassociates an evidence folder from the specified assessment report in Audit Manager.

    Args:
        assessment_id(str):  The identifier for the specified assessment. .
        evidence_folder_id(str):  The identifier for the folder in which evidence is stored. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.assessment.report.evidence_folder.disassociate(
                ctx, assessment_id=value, evidence_folder_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.assessment.report.evidence_folder.disassociate assessment_id=value, evidence_folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="disassociate_assessment_report_evidence_folder",
        op_kwargs={
            "assessmentId": assessment_id,
            "evidenceFolderId": evidence_folder_id,
        },
    )
