"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    assessment_reports_destination: Dict,
    scope: Dict,
    roles: List,
    framework_id: str,
    description: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates an assessment in Audit Manager.

    Args:
        name(str):  The name of the assessment to be created. .
        description(str, optional):  The optional description of the assessment to be created. . Defaults to None.
        assessment_reports_destination(Dict):  The assessment report storage destination for the specified assessment that is being created. .
        scope(Dict):  The wrapper that contains the accounts and services in scope for the assessment. .
        roles(List):  The list of roles for the specified assessment. .
        framework_id(str):  The identifier for the specified framework. .
        tags(Dict, optional):  The tags associated with the assessment. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.assessment.init.create(
                ctx,
                name=value,
                assessment_reports_destination=value,
                scope=value,
                roles=value,
                framework_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.assessment.init.create name=value, assessment_reports_destination=value, scope=value, roles=value, framework_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="create_assessment",
        op_kwargs={
            "name": name,
            "description": description,
            "assessmentReportsDestination": assessment_reports_destination,
            "scope": scope,
            "roles": roles,
            "frameworkId": framework_id,
            "tags": tags,
        },
    )


async def delete(hub, ctx, assessment_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes an assessment in Audit Manager.

    Args:
        assessment_id(str):  The identifier for the specified assessment. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.assessment.init.delete(ctx, assessment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.assessment.init.delete assessment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="delete_assessment",
        op_kwargs={"assessmentId": assessment_id},
    )


async def get(hub, ctx, assessment_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns an assessment from Audit Manager.

    Args:
        assessment_id(str):  The identifier for the specified assessment. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.assessment.init.get(ctx, assessment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.assessment.init.get assessment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="get_assessment",
        op_kwargs={"assessmentId": assessment_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of current and past assessments from Audit Manager.

    Args:
        next_token(str, optional):  The pagination token used to fetch the next set of results. . Defaults to None.
        max_results(int, optional):  Represents the maximum number of results per page, or per API request call. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.assessment.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.assessment.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="list_assessments",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    assessment_id: str,
    scope: Dict,
    assessment_name: str = None,
    assessment_description: str = None,
    assessment_reports_destination: Dict = None,
    roles: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Edits an Audit Manager assessment.

    Args:
        assessment_id(str):  The identifier for the specified assessment. .
        assessment_name(str, optional):  The name of the specified assessment to be updated. . Defaults to None.
        assessment_description(str, optional):  The description of the specified assessment. . Defaults to None.
        scope(Dict):  The scope of the specified assessment. .
        assessment_reports_destination(Dict, optional):  The assessment report storage destination for the specified assessment that is being updated. . Defaults to None.
        roles(List, optional):  The list of roles for the specified assessment. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.assessment.init.update(
                ctx, assessment_id=value, scope=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.assessment.init.update assessment_id=value, scope=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="update_assessment",
        op_kwargs={
            "assessmentId": assessment_id,
            "assessmentName": assessment_name,
            "assessmentDescription": assessment_description,
            "scope": scope,
            "assessmentReportsDestination": assessment_reports_destination,
            "roles": roles,
        },
    )
