"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, assessment_id: str, control_set_id: str, status: str, comment: str
) -> Dict:
    r"""
    **Autogenerated function**

     Updates the status of a control set in an Audit Manager assessment.

    Args:
        assessment_id(str):  The identifier for the specified assessment. .
        control_set_id(str):  The identifier for the specified control set. .
        status(str):  The status of the control set that is being updated. .
        comment(str):  The comment related to the status update. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.assessment.control.set_status.update(
                ctx, assessment_id=value, control_set_id=value, status=value, comment=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.assessment.control.set_status.update assessment_id=value, control_set_id=value, status=value, comment=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="update_assessment_control_set_status",
        op_kwargs={
            "assessmentId": assessment_id,
            "controlSetId": control_set_id,
            "status": status,
            "comment": comment,
        },
    )
