"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub,
    ctx,
    assessment_id: str,
    control_set_id: str,
    control_id: str,
    control_status: str = None,
    comment_body: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Updates a control within an assessment in Audit Manager.

    Args:
        assessment_id(str):  The identifier for the specified assessment. .
        control_set_id(str):  The identifier for the specified control set. .
        control_id(str):  The identifier for the specified control. .
        control_status(str, optional):  The status of the specified control. . Defaults to None.
        comment_body(str, optional):  The comment body text for the specified control. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.assessment.control.init.update(
                ctx, assessment_id=value, control_set_id=value, control_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.assessment.control.init.update assessment_id=value, control_set_id=value, control_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="update_assessment_control",
        op_kwargs={
            "assessmentId": assessment_id,
            "controlSetId": control_set_id,
            "controlId": control_id,
            "controlStatus": control_status,
            "commentBody": comment_body,
        },
    )
