"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def deregister(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

     Deregisters an account in Audit Manager.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.account.init.deregister(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.account.init.deregister
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="auditmanager", operation="deregister_account", op_kwargs={}
    )


async def register(
    hub, ctx, kms_key: str = None, delegated_admin_account: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Enables Audit Manager for the specified account.

    Args:
        kms_key(str, optional):  The KMS key details. . Defaults to None.
        delegated_admin_account(str, optional):  The delegated administrator account for Audit Manager. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.auditmanager.account.init.register(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.auditmanager.account.init.register
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="auditmanager",
        operation="register_account",
        op_kwargs={"kmsKey": kms_key, "delegatedAdminAccount": delegated_admin_account},
    )
