"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    configuration: Dict = None,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a workgroup with the specified name.

    Args:
        name(str): The workgroup name.
        configuration(Dict, optional): The configuration for the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption configuration, if any, used for encrypting query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, the limit for the amount of bytes scanned (cutoff) per query, if it is specified, and whether workgroup's settings (specified with EnforceWorkGroupConfiguration) in the WorkGroupConfiguration override client-side settings. See WorkGroupConfiguration$EnforceWorkGroupConfiguration. Defaults to None.
        description(str, optional): The workgroup description. Defaults to None.
        tags(List, optional): A list of comma separated tags to add to the workgroup that is created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.work_group.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.work_group.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="create_work_group",
        op_kwargs={
            "Name": name,
            "Configuration": configuration,
            "Description": description,
            "Tags": tags,
        },
    )


async def delete(
    hub, ctx, work_group: str, recursive_delete_option: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the workgroup with the specified name. The primary workgroup cannot be deleted.

    Args:
        work_group(str): The unique name of the workgroup to delete.
        recursive_delete_option(bool, optional): The option to delete the workgroup and its contents even if the workgroup contains any named queries or query executions. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.work_group.delete(ctx, work_group=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.work_group.delete work_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="delete_work_group",
        op_kwargs={
            "WorkGroup": work_group,
            "RecursiveDeleteOption": recursive_delete_option,
        },
    )


async def get(hub, ctx, work_group: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the workgroup with the specified name.

    Args:
        work_group(str): The name of the workgroup.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.work_group.get(ctx, work_group=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.work_group.get work_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="get_work_group",
        op_kwargs={"WorkGroup": work_group},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists available workgroups for the account.

    Args:
        next_token(str, optional): A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call. Defaults to None.
        max_results(int, optional): The maximum number of workgroups to return in this request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.work_group.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.work_group.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="list_work_groups",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(
    hub,
    ctx,
    work_group: str,
    description: str = None,
    configuration_updates: Dict = None,
    state: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the workgroup with the specified name. The workgroup's name cannot be changed.

    Args:
        work_group(str): The specified workgroup that will be updated.
        description(str, optional): The workgroup description. Defaults to None.
        configuration_updates(Dict, optional): The workgroup configuration that will be updated for the given workgroup. Defaults to None.
        state(str, optional): The workgroup state that will be updated for the given workgroup. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.work_group.update(ctx, work_group=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.work_group.update work_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="update_work_group",
        op_kwargs={
            "WorkGroup": work_group,
            "Description": description,
            "ConfigurationUpdates": configuration_updates,
            "State": state,
        },
    )
