"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, resource_arn: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the tags associated with an Athena workgroup or data catalog resource.

    Args:
        resource_arn(str): Lists the tags for the resource with the specified ARN.
        next_token(str, optional): The token for the next set of results, or null if there are no additional results for this request, where the request lists the tags for the resource with the specified ARN. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request that lists the tags for the resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.tags_for_resource.list(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.tags_for_resource.list resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="list_tags_for_resource",
        op_kwargs={
            "ResourceARN": resource_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
