"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, query_execution_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Streams the results of a single query execution specified by QueryExecutionId from the Athena query results location in Amazon S3. For more information, see Query Results in the Amazon Athena User Guide. This request does not execute the query but returns results. Use StartQueryExecution to run a query. To stream query results successfully, the IAM principal with permission to call GetQueryResults also must have permissions to the Amazon S3 GetObject action for the Athena query results location.  IAM principals with permission to the Amazon S3 GetObject action for the query results location are able to retrieve query results from Amazon S3 even if permission to the GetQueryResults action is denied. To restrict user or role access, ensure that Amazon S3 permissions to the Athena query location are denied.

    Args:
        query_execution_id(str): The unique ID of the query execution.
        next_token(str, optional): A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call. Defaults to None.
        max_results(int, optional): The maximum number of results (rows) to return in this request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.query.result.get_all(ctx, query_execution_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.query.result.get_all query_execution_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="get_query_results",
        op_kwargs={
            "QueryExecutionId": query_execution_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
