"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, query_execution_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a single execution of a query if you have access to the workgroup in which the query ran. Each time a query executes, information about the query execution is saved with a unique ID.

    Args:
        query_execution_id(str): The unique ID of the query execution.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.query.execution.get(ctx, query_execution_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.query.execution.get query_execution_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="get_query_execution",
        op_kwargs={"QueryExecutionId": query_execution_id},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, work_group: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Provides a list of available query execution IDs for the queries in the specified workgroup. If a workgroup is not specified, returns a list of query execution IDs for the primary workgroup. Requires you to have access to the workgroup in which the queries ran. For code samples using the AWS SDK for Java, see Examples and Code Samples in the Amazon Athena User Guide.

    Args:
        next_token(str, optional): A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call. Defaults to None.
        max_results(int, optional): The maximum number of query executions to return in this request. Defaults to None.
        work_group(str, optional): The name of the workgroup from which queries are being returned. If a workgroup is not specified, a list of available query execution IDs for the queries in the primary workgroup is returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.query.execution.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.query.execution.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="list_query_executions",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "WorkGroup": work_group,
        },
    )


async def start(
    hub,
    ctx,
    query_string: str,
    client_request_token: str = None,
    query_execution_context: Dict = None,
    result_configuration: Dict = None,
    work_group: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Runs the SQL query statements contained in the Query. Requires you to have access to the workgroup in which the query ran. Running queries against an external catalog requires GetDataCatalog permission to the catalog. For code samples using the AWS SDK for Java, see Examples and Code Samples in the Amazon Athena User Guide.

    Args:
        query_string(str): The SQL query statements to be executed.
        client_request_token(str, optional): A unique case-sensitive string used to ensure the request to create the query is idempotent (executes only once). If another StartQueryExecution request is received, the same response is returned and another query is not created. If a parameter has changed, for example, the QueryString, an error is returned.  This token is listed as not required because AWS SDKs (for example the AWS SDK for Java) auto-generate the token for users. If you are not using the AWS SDK or the AWS CLI, you must provide this token or the action will fail. . Defaults to None.
        query_execution_context(Dict, optional): The database within which the query executes. Defaults to None.
        result_configuration(Dict, optional): Specifies information about where and how to save the results of the query execution. If the query runs in a workgroup, then workgroup's settings may override query settings. This affects the query results location. The workgroup settings override is specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See WorkGroupConfiguration$EnforceWorkGroupConfiguration. Defaults to None.
        work_group(str, optional): The name of the workgroup in which the query is being started. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.query.execution.start(ctx, query_string=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.query.execution.start query_string=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="start_query_execution",
        op_kwargs={
            "QueryString": query_string,
            "ClientRequestToken": client_request_token,
            "QueryExecutionContext": query_execution_context,
            "ResultConfiguration": result_configuration,
            "WorkGroup": work_group,
        },
    )


async def stop(hub, ctx, query_execution_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops a query execution. Requires you to have access to the workgroup in which the query ran. For code samples using the AWS SDK for Java, see Examples and Code Samples in the Amazon Athena User Guide.

    Args:
        query_execution_id(str): The unique ID of the query execution to stop.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.query.execution.stop(ctx, query_execution_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.query.execution.stop query_execution_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="stop_query_execution",
        op_kwargs={"QueryExecutionId": query_execution_id},
    )
