"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    statement_name: str,
    work_group: str,
    query_statement: str,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a prepared statement for use with SQL queries in Athena.

    Args:
        statement_name(str): The name of the prepared statement.
        work_group(str): The name of the workgroup to which the prepared statement belongs.
        query_statement(str): The query string for the prepared statement.
        description(str, optional): The description of the prepared statement. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.prepared_statement.create(
                ctx, statement_name=value, work_group=value, query_statement=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.prepared_statement.create statement_name=value, work_group=value, query_statement=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="create_prepared_statement",
        op_kwargs={
            "StatementName": statement_name,
            "WorkGroup": work_group,
            "QueryStatement": query_statement,
            "Description": description,
        },
    )


async def delete(hub, ctx, statement_name: str, work_group: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the prepared statement with the specified name from the specified workgroup.

    Args:
        statement_name(str): The name of the prepared statement to delete.
        work_group(str): The workgroup to which the statement to be deleted belongs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.prepared_statement.delete(
                ctx, statement_name=value, work_group=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.prepared_statement.delete statement_name=value, work_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="delete_prepared_statement",
        op_kwargs={"StatementName": statement_name, "WorkGroup": work_group},
    )


async def get(hub, ctx, statement_name: str, work_group: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the prepared statement with the specified name from the specified workgroup.

    Args:
        statement_name(str): The name of the prepared statement to retrieve.
        work_group(str): The workgroup to which the statement to be retrieved belongs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.prepared_statement.get(
                ctx, statement_name=value, work_group=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.prepared_statement.get statement_name=value, work_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="get_prepared_statement",
        op_kwargs={"StatementName": statement_name, "WorkGroup": work_group},
    )


async def list_all(
    hub, ctx, work_group: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the prepared statements in the specfied workgroup.

    Args:
        work_group(str): The workgroup to list the prepared statements for.
        next_token(str, optional): A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call. Defaults to None.
        max_results(int, optional): The maximum number of results to return in this request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.prepared_statement.list_all(ctx, work_group=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.prepared_statement.list_all work_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="list_prepared_statements",
        op_kwargs={
            "WorkGroup": work_group,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    statement_name: str,
    work_group: str,
    query_statement: str,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a prepared statement.

    Args:
        statement_name(str): The name of the prepared statement.
        work_group(str): The workgroup for the prepared statement.
        query_statement(str): The query string for the prepared statement.
        description(str, optional): The description of the prepared statement. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.prepared_statement.update(
                ctx, statement_name=value, work_group=value, query_statement=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.prepared_statement.update statement_name=value, work_group=value, query_statement=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="update_prepared_statement",
        op_kwargs={
            "StatementName": statement_name,
            "WorkGroup": work_group,
            "QueryStatement": query_statement,
            "Description": description,
        },
    )
