"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    database: str,
    query_string: str,
    description: str = None,
    client_request_token: str = None,
    work_group: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a named query in the specified workgroup. Requires that you have access to the workgroup. For code samples using the AWS SDK for Java, see Examples and Code Samples in the Amazon Athena User Guide.

    Args:
        name(str): The query name.
        description(str, optional): The query description. Defaults to None.
        database(str): The database to which the query belongs.
        query_string(str): The contents of the query with all query statements.
        client_request_token(str, optional): A unique case-sensitive string used to ensure the request to create the query is idempotent (executes only once). If another CreateNamedQuery request is received, the same response is returned and another query is not created. If a parameter has changed, for example, the QueryString, an error is returned.  This token is listed as not required because AWS SDKs (for example the AWS SDK for Java) auto-generate the token for users. If you are not using the AWS SDK or the AWS CLI, you must provide this token or the action will fail. . Defaults to None.
        work_group(str, optional): The name of the workgroup in which the named query is being created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.named_query.create(
                ctx, name=value, database=value, query_string=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.named_query.create name=value, database=value, query_string=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="create_named_query",
        op_kwargs={
            "Name": name,
            "Description": description,
            "Database": database,
            "QueryString": query_string,
            "ClientRequestToken": client_request_token,
            "WorkGroup": work_group,
        },
    )


async def delete(hub, ctx, named_query_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the named query if you have access to the workgroup in which the query was saved. For code samples using the AWS SDK for Java, see Examples and Code Samples in the Amazon Athena User Guide.

    Args:
        named_query_id(str): The unique ID of the query to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.named_query.delete(ctx, named_query_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.named_query.delete named_query_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="delete_named_query",
        op_kwargs={"NamedQueryId": named_query_id},
    )


async def get(hub, ctx, named_query_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a single query. Requires that you have access to the workgroup in which the query was saved.

    Args:
        named_query_id(str): The unique ID of the query. Use ListNamedQueries to get query IDs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.named_query.get(ctx, named_query_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.named_query.get named_query_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="get_named_query",
        op_kwargs={"NamedQueryId": named_query_id},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, work_group: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Provides a list of available query IDs only for queries saved in the specified workgroup. Requires that you have access to the specified workgroup. If a workgroup is not specified, lists the saved queries for the primary workgroup. For code samples using the AWS SDK for Java, see Examples and Code Samples in the Amazon Athena User Guide.

    Args:
        next_token(str, optional): A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call. Defaults to None.
        max_results(int, optional): The maximum number of queries to return in this request. Defaults to None.
        work_group(str, optional): The name of the workgroup from which the named queries are being returned. If a workgroup is not specified, the saved queries for the primary workgroup are returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.named_query.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.named_query.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="list_named_queries",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "WorkGroup": work_group,
        },
    )
