"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, query_execution_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an array of query execution ID strings. Requires you to have access to the workgroup in which the queries ran. To get a list of query execution IDs, use ListQueryExecutionsInput$WorkGroup. Query executions differ from named (saved) queries. Use BatchGetNamedQueryInput to get details about named queries.

    Args:
        query_execution_ids(List): An array of query execution IDs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.get.query_execution.batch(ctx, query_execution_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.get.query_execution.batch query_execution_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="batch_get_query_execution",
        op_kwargs={"QueryExecutionIds": query_execution_ids},
    )
