"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, named_query_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query ID strings. Requires you to have access to the workgroup in which the queries were saved. Use ListNamedQueriesInput to get the list of named query IDs in the specified workgroup. If information could not be retrieved for a submitted query ID, information about the query ID submitted is listed under UnprocessedNamedQueryId. Named queries differ from executed queries. Use BatchGetQueryExecutionInput to get details about each unique query execution, and ListQueryExecutionsInput to get a list of query execution IDs.

    Args:
        named_query_ids(List): An array of query IDs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.get.named_query.batch(ctx, named_query_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.get.named_query.batch named_query_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="batch_get_named_query",
        op_kwargs={"NamedQueryIds": named_query_ids},
    )
