"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of engine versions that are available to choose from, including the Auto option.

    Args:
        next_token(str, optional): A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call. Defaults to None.
        max_results(int, optional): The maximum number of engine versions to return in this request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.engine_version.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.engine_version.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="list_engine_versions",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
