"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, catalog_name: str, database_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a database object for the specified database and data catalog.

    Args:
        catalog_name(str): The name of the data catalog that contains the database to return.
        database_name(str): The name of the database to return.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.database.get(
                ctx, catalog_name=value, database_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.database.get catalog_name=value, database_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="get_database",
        op_kwargs={"CatalogName": catalog_name, "DatabaseName": database_name},
    )


async def list_all(
    hub, ctx, catalog_name: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the databases in the specified data catalog.

    Args:
        catalog_name(str): The name of the data catalog that contains the databases to return.
        next_token(str, optional): A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call. Defaults to None.
        max_results(int, optional): Specifies the maximum number of results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.database.list_all(ctx, catalog_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.database.list_all catalog_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="list_databases",
        op_kwargs={
            "CatalogName": catalog_name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
