"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    type_: str,
    description: str = None,
    parameters: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates (registers) a data catalog with the specified name and properties. Catalogs created are visible to all users of the same AWS account.

    Args:
        name(str): The name of the data catalog to create. The catalog name must be unique for the AWS account and can use a maximum of 128 alphanumeric, underscore, at sign, or hyphen characters.
        type_(str): The type of data catalog to create: LAMBDA for a federated catalog or HIVE for an external hive metastore.  Do not use the GLUE type. This refers to the AwsDataCatalog that already exists in your account, of which you can have only one. Specifying the GLUE type will result in an INVALID_INPUT error. .
        description(str, optional): A description of the data catalog to be created. Defaults to None.
        parameters(Dict, optional): Specifies the Lambda function or functions to use for creating the data catalog. This is a mapping whose values depend on the catalog type.    For the HIVE data catalog type, use the following syntax. The metadata-function parameter is required. The sdk-version parameter is optional and defaults to the currently supported version.  metadata-function=lambda_arn, sdk-version=version_number     For the LAMBDA data catalog type, use one of the following sets of required parameters, but not both.   If you have one Lambda function that processes metadata and another for reading the actual data, use the following syntax. Both parameters are required.  metadata-function=lambda_arn, record-function=lambda_arn      If you have a composite Lambda function that processes both metadata and data, use the following syntax to specify your Lambda function.  function=lambda_arn      . Defaults to None.
        tags(List, optional): A list of comma separated tags to add to the data catalog that is created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.data.catalog.create(ctx, name=value, type_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.data.catalog.create name=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="create_data_catalog",
        op_kwargs={
            "Name": name,
            "Type": type_,
            "Description": description,
            "Parameters": parameters,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a data catalog.

    Args:
        name(str): The name of the data catalog to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.data.catalog.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.data.catalog.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="delete_data_catalog",
        op_kwargs={"Name": name},
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the specified data catalog.

    Args:
        name(str): The name of the data catalog to return.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.data.catalog.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.data.catalog.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="get_data_catalog",
        op_kwargs={"Name": name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the data catalogs in the current AWS account.

    Args:
        next_token(str, optional): A token generated by the Athena service that specifies where to continue pagination if a previous request was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page call. Defaults to None.
        max_results(int, optional): Specifies the maximum number of data catalogs to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.data.catalog.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.data.catalog.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="list_data_catalogs",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(
    hub, ctx, name: str, type_: str, description: str = None, parameters: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the data catalog that has the specified name.

    Args:
        name(str): The name of the data catalog to update. The catalog name must be unique for the AWS account and can use a maximum of 128 alphanumeric, underscore, at sign, or hyphen characters.
        type_(str): Specifies the type of data catalog to update. Specify LAMBDA for a federated catalog or HIVE for an external hive metastore.  Do not use the GLUE type. This refers to the AwsDataCatalog that already exists in your account, of which you can have only one. Specifying the GLUE type will result in an INVALID_INPUT error. .
        description(str, optional): New or modified text that describes the data catalog. Defaults to None.
        parameters(Dict, optional): Specifies the Lambda function or functions to use for updating the data catalog. This is a mapping whose values depend on the catalog type.    For the HIVE data catalog type, use the following syntax. The metadata-function parameter is required. The sdk-version parameter is optional and defaults to the currently supported version.  metadata-function=lambda_arn, sdk-version=version_number     For the LAMBDA data catalog type, use one of the following sets of required parameters, but not both.   If you have one Lambda function that processes metadata and another for reading the actual data, use the following syntax. Both parameters are required.  metadata-function=lambda_arn, record-function=lambda_arn      If you have a composite Lambda function that processes both metadata and data, use the following syntax to specify your Lambda function.  function=lambda_arn      . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.athena.data.catalog.update(ctx, name=value, type_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.athena.data.catalog.update name=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="athena",
        operation="update_data_catalog",
        op_kwargs={
            "Name": name,
            "Type": type_,
            "Description": description,
            "Parameters": parameters,
        },
    )
