"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(hub, ctx, api_id: str, definition: bytes) -> Dict:
    r"""
    **Autogenerated function**

    Adds a new schema to your GraphQL API. This operation is asynchronous. Use to determine when it has completed.

    Args:
        api_id(str): The API ID.
        definition(bytes): The schema definition, in GraphQL schema language format.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.schema_creation.init.start(
                ctx, api_id=value, definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.schema_creation.init.start api_id=value, definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="start_schema_creation",
        op_kwargs={"apiId": api_id, "definition": definition},
    )
