"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    api_id: str,
    type_name: str,
    field_name: str,
    data_source_name: str = None,
    request_mapping_template: str = None,
    response_mapping_template: str = None,
    kind: str = None,
    pipeline_config: Dict = None,
    sync_config: Dict = None,
    caching_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Resolver object. A resolver converts incoming requests into a format that a data source can understand and converts the data source's responses into GraphQL.

    Args:
        api_id(str): The ID for the GraphQL API for which the resolver is being created.
        type_name(str): The name of the Type.
        field_name(str): The name of the field to attach the resolver to.
        data_source_name(str, optional): The name of the data source for which the resolver is being created. Defaults to None.
        request_mapping_template(str, optional): The mapping template to be used for requests. A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL). VTL request mapping templates are optional when using a Lambda data source. For all other data sources, VTL request and response mapping templates are required. Defaults to None.
        response_mapping_template(str, optional): The mapping template to be used for responses from the data source. Defaults to None.
        kind(str, optional): The resolver type.    UNIT: A UNIT resolver type. A UNIT resolver is the default resolver type. A UNIT resolver enables you to execute a GraphQL query against a single data source.    PIPELINE: A PIPELINE resolver type. A PIPELINE resolver enables you to execute a series of Function in a serial manner. You can use a pipeline resolver to execute a GraphQL query against multiple data sources.  . Defaults to None.
        pipeline_config(Dict, optional): The PipelineConfig. Defaults to None.
        sync_config(Dict, optional): The SyncConfig for a resolver attached to a versioned datasource. Defaults to None.
        caching_config(Dict, optional): The caching configuration for the resolver. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.resolver.init.create(
                ctx, api_id=value, type_name=value, field_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.resolver.init.create api_id=value, type_name=value, field_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="create_resolver",
        op_kwargs={
            "apiId": api_id,
            "typeName": type_name,
            "fieldName": field_name,
            "dataSourceName": data_source_name,
            "requestMappingTemplate": request_mapping_template,
            "responseMappingTemplate": response_mapping_template,
            "kind": kind,
            "pipelineConfig": pipeline_config,
            "syncConfig": sync_config,
            "cachingConfig": caching_config,
        },
    )


async def delete(hub, ctx, api_id: str, type_name: str, field_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a Resolver object.

    Args:
        api_id(str): The API ID.
        type_name(str): The name of the resolver type.
        field_name(str): The resolver field name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.resolver.init.delete(
                ctx, api_id=value, type_name=value, field_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.resolver.init.delete api_id=value, type_name=value, field_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="delete_resolver",
        op_kwargs={"apiId": api_id, "typeName": type_name, "fieldName": field_name},
    )


async def get(hub, ctx, api_id: str, type_name: str, field_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a Resolver object.

    Args:
        api_id(str): The API ID.
        type_name(str): The resolver type name.
        field_name(str): The resolver field name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.resolver.init.get(
                ctx, api_id=value, type_name=value, field_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.resolver.init.get api_id=value, type_name=value, field_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="get_resolver",
        op_kwargs={"apiId": api_id, "typeName": type_name, "fieldName": field_name},
    )


async def list_all(
    hub,
    ctx,
    api_id: str,
    type_name: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the resolvers for a given API and type.

    Args:
        api_id(str): The API ID.
        type_name(str): The type name.
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. . Defaults to None.
        max_results(int, optional): The maximum number of results you want the request to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.resolver.init.list_all(
                ctx, api_id=value, type_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.resolver.init.list_all api_id=value, type_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="list_resolvers",
        op_kwargs={
            "apiId": api_id,
            "typeName": type_name,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    api_id: str,
    type_name: str,
    field_name: str,
    data_source_name: str = None,
    request_mapping_template: str = None,
    response_mapping_template: str = None,
    kind: str = None,
    pipeline_config: Dict = None,
    sync_config: Dict = None,
    caching_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a Resolver object.

    Args:
        api_id(str): The API ID.
        type_name(str): The new type name.
        field_name(str): The new field name.
        data_source_name(str, optional): The new data source name. Defaults to None.
        request_mapping_template(str, optional): The new request mapping template. A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL). VTL request mapping templates are optional when using a Lambda data source. For all other data sources, VTL request and response mapping templates are required. Defaults to None.
        response_mapping_template(str, optional): The new response mapping template. Defaults to None.
        kind(str, optional): The resolver type.    UNIT: A UNIT resolver type. A UNIT resolver is the default resolver type. A UNIT resolver enables you to execute a GraphQL query against a single data source.    PIPELINE: A PIPELINE resolver type. A PIPELINE resolver enables you to execute a series of Function in a serial manner. You can use a pipeline resolver to execute a GraphQL query against multiple data sources.  . Defaults to None.
        pipeline_config(Dict, optional): The PipelineConfig. Defaults to None.
        sync_config(Dict, optional): The SyncConfig for a resolver attached to a versioned datasource. Defaults to None.
        caching_config(Dict, optional): The caching configuration for the resolver. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.resolver.init.update(
                ctx, api_id=value, type_name=value, field_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.resolver.init.update api_id=value, type_name=value, field_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="update_resolver",
        op_kwargs={
            "apiId": api_id,
            "typeName": type_name,
            "fieldName": field_name,
            "dataSourceName": data_source_name,
            "requestMappingTemplate": request_mapping_template,
            "responseMappingTemplate": response_mapping_template,
            "kind": kind,
            "pipelineConfig": pipeline_config,
            "syncConfig": sync_config,
            "cachingConfig": caching_config,
        },
    )
