"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    api_id: str,
    function_id: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List the resolvers that are associated with a specific function.

    Args:
        api_id(str): The API ID.
        function_id(str): The Function ID.
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list. Defaults to None.
        max_results(int, optional): The maximum number of results you want the request to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.resolver.by_function.list(
                ctx, api_id=value, function_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.resolver.by_function.list api_id=value, function_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="list_resolvers_by_function",
        op_kwargs={
            "apiId": api_id,
            "functionId": function_id,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
