"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, api_id: str, format_: str, include_directives: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the introspection schema for a GraphQL API.

    Args:
        api_id(str): The API ID.
        format_(str): The schema format: SDL or JSON.
        include_directives(bool, optional): A flag that specifies whether the schema introspection should contain directives. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.introspection_schema.get(
                ctx, api_id=value, format_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.introspection_schema.get api_id=value, format_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="get_introspection_schema",
        op_kwargs={
            "apiId": api_id,
            "format": format_,
            "includeDirectives": include_directives,
        },
    )
