"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists your GraphQL APIs.

    Args:
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. . Defaults to None.
        max_results(int, optional): The maximum number of results you want the request to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.graphql_apis.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.graphql_apis.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="list_graphql_apis",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )
