"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    authentication_type: str,
    log_config: Dict = None,
    user_pool_config: Dict = None,
    open_id_connect_config: Dict = None,
    tags: Dict = None,
    additional_authentication_providers: List = None,
    xray_enabled: bool = None,
    lambda_authorizer_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a GraphqlApi object.

    Args:
        name(str): A user-supplied name for the GraphqlApi.
        log_config(Dict, optional): The Amazon CloudWatch Logs configuration. Defaults to None.
        authentication_type(str): The authentication type: API key, Identity and Access Management, OIDC, or Amazon Cognito user pools.
        user_pool_config(Dict, optional): The Amazon Cognito user pool configuration. Defaults to None.
        open_id_connect_config(Dict, optional): The OpenID Connect configuration. Defaults to None.
        tags(Dict, optional): A TagMap object. Defaults to None.
        additional_authentication_providers(List, optional): A list of additional authentication providers for the GraphqlApi API. Defaults to None.
        xray_enabled(bool, optional): A flag indicating whether to enable X-Ray tracing for the GraphqlApi. Defaults to None.
        lambda_authorizer_config(Dict, optional): Configuration for AWS Lambda function authorization. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.graphql_api.create(
                ctx, name=value, authentication_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.graphql_api.create name=value, authentication_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="create_graphql_api",
        op_kwargs={
            "name": name,
            "logConfig": log_config,
            "authenticationType": authentication_type,
            "userPoolConfig": user_pool_config,
            "openIDConnectConfig": open_id_connect_config,
            "tags": tags,
            "additionalAuthenticationProviders": additional_authentication_providers,
            "xrayEnabled": xray_enabled,
            "lambdaAuthorizerConfig": lambda_authorizer_config,
        },
    )


async def delete(hub, ctx, api_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a GraphqlApi object.

    Args:
        api_id(str): The API ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.graphql_api.delete(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.graphql_api.delete api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="delete_graphql_api",
        op_kwargs={"apiId": api_id},
    )


async def get(hub, ctx, api_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a GraphqlApi object.

    Args:
        api_id(str): The API ID for the GraphQL API.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.graphql_api.get(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.graphql_api.get api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="get_graphql_api",
        op_kwargs={"apiId": api_id},
    )


async def update(
    hub,
    ctx,
    api_id: str,
    name: str,
    log_config: Dict = None,
    authentication_type: str = None,
    user_pool_config: Dict = None,
    open_id_connect_config: Dict = None,
    additional_authentication_providers: List = None,
    xray_enabled: bool = None,
    lambda_authorizer_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a GraphqlApi object.

    Args:
        api_id(str): The API ID.
        name(str): The new name for the GraphqlApi object.
        log_config(Dict, optional): The Amazon CloudWatch Logs configuration for the GraphqlApi object. Defaults to None.
        authentication_type(str, optional): The new authentication type for the GraphqlApi object. Defaults to None.
        user_pool_config(Dict, optional): The new Amazon Cognito user pool configuration for the GraphqlApi object. Defaults to None.
        open_id_connect_config(Dict, optional): The OpenID Connect configuration for the GraphqlApi object. Defaults to None.
        additional_authentication_providers(List, optional): A list of additional authentication providers for the GraphqlApi API. Defaults to None.
        xray_enabled(bool, optional): A flag indicating whether to enable X-Ray tracing for the GraphqlApi. Defaults to None.
        lambda_authorizer_config(Dict, optional): Configuration for AWS Lambda function authorization. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.graphql_api.update(ctx, api_id=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.graphql_api.update api_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="update_graphql_api",
        op_kwargs={
            "apiId": api_id,
            "name": name,
            "logConfig": log_config,
            "authenticationType": authentication_type,
            "userPoolConfig": user_pool_config,
            "openIDConnectConfig": open_id_connect_config,
            "additionalAuthenticationProviders": additional_authentication_providers,
            "xrayEnabled": xray_enabled,
            "lambdaAuthorizerConfig": lambda_authorizer_config,
        },
    )
