"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    api_id: str,
    name: str,
    data_source_name: str,
    function_version: str,
    description: str = None,
    request_mapping_template: str = None,
    response_mapping_template: str = None,
    sync_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Function object. A function is a reusable entity. Multiple functions can be used to compose the resolver logic.

    Args:
        api_id(str): The GraphQL API ID.
        name(str): The Function name. The function name does not have to be unique.
        description(str, optional): The Function description. Defaults to None.
        data_source_name(str): The Function DataSource name.
        request_mapping_template(str, optional): The Function request mapping template. Functions support only the 2018-05-29 version of the request mapping template. Defaults to None.
        response_mapping_template(str, optional): The Function response mapping template. . Defaults to None.
        function_version(str): The version of the request mapping template. Currently the supported value is 2018-05-29. .
        sync_config(Dict, optional): Describes a Sync configuration for a resolver. Contains information on which Conflict Detection as well as Resolution strategy should be performed when the resolver is invoked. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.function.create(
                ctx, api_id=value, name=value, data_source_name=value, function_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.function.create api_id=value, name=value, data_source_name=value, function_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="create_function",
        op_kwargs={
            "apiId": api_id,
            "name": name,
            "description": description,
            "dataSourceName": data_source_name,
            "requestMappingTemplate": request_mapping_template,
            "responseMappingTemplate": response_mapping_template,
            "functionVersion": function_version,
            "syncConfig": sync_config,
        },
    )


async def delete(hub, ctx, api_id: str, function_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a Function.

    Args:
        api_id(str): The GraphQL API ID.
        function_id(str): The Function ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.function.delete(ctx, api_id=value, function_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.function.delete api_id=value, function_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="delete_function",
        op_kwargs={"apiId": api_id, "functionId": function_id},
    )


async def get(hub, ctx, api_id: str, function_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Get a Function.

    Args:
        api_id(str): The GraphQL API ID.
        function_id(str): The Function ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.function.get(ctx, api_id=value, function_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.function.get api_id=value, function_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="get_function",
        op_kwargs={"apiId": api_id, "functionId": function_id},
    )


async def list_all(
    hub, ctx, api_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    List multiple functions.

    Args:
        api_id(str): The GraphQL API ID.
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.
        max_results(int, optional): The maximum number of results you want the request to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.function.list_all(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.function.list_all api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="list_functions",
        op_kwargs={"apiId": api_id, "nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    api_id: str,
    name: str,
    function_id: str,
    data_source_name: str,
    function_version: str,
    description: str = None,
    request_mapping_template: str = None,
    response_mapping_template: str = None,
    sync_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a Function object.

    Args:
        api_id(str): The GraphQL API ID.
        name(str): The Function name.
        description(str, optional): The Function description. Defaults to None.
        function_id(str): The function ID.
        data_source_name(str): The Function DataSource name.
        request_mapping_template(str, optional): The Function request mapping template. Functions support only the 2018-05-29 version of the request mapping template. Defaults to None.
        response_mapping_template(str, optional): The Function request mapping template. . Defaults to None.
        function_version(str): The version of the request mapping template. Currently the supported value is 2018-05-29. .
        sync_config(Dict, optional): Describes a Sync configuration for a resolver. Contains information on which Conflict Detection as well as Resolution strategy should be performed when the resolver is invoked. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.function.update(
                ctx,
                api_id=value,
                name=value,
                function_id=value,
                data_source_name=value,
                function_version=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.function.update api_id=value, name=value, function_id=value, data_source_name=value, function_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="update_function",
        op_kwargs={
            "apiId": api_id,
            "name": name,
            "description": description,
            "functionId": function_id,
            "dataSourceName": data_source_name,
            "requestMappingTemplate": request_mapping_template,
            "responseMappingTemplate": response_mapping_template,
            "functionVersion": function_version,
            "syncConfig": sync_config,
        },
    )
