"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    api_id: str,
    name: str,
    type_: str,
    description: str = None,
    service_role_arn: str = None,
    dynamodb_config: Dict = None,
    lambda_config: Dict = None,
    elasticsearch_config: Dict = None,
    http_config: Dict = None,
    relational_database_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a DataSource object.

    Args:
        api_id(str): The API ID for the GraphQL API for the DataSource.
        name(str): A user-supplied name for the DataSource.
        description(str, optional): A description of the DataSource. Defaults to None.
        type_(str): The type of the DataSource.
        service_role_arn(str, optional): The Identity and Access Management service role ARN for the data source. The system assumes this role when accessing the data source. Defaults to None.
        dynamodb_config(Dict, optional): Amazon DynamoDB settings. Defaults to None.
        lambda_config(Dict, optional): Amazon Web Services Lambda settings. Defaults to None.
        elasticsearch_config(Dict, optional): Amazon Elasticsearch Service settings. Defaults to None.
        http_config(Dict, optional): HTTP endpoint settings. Defaults to None.
        relational_database_config(Dict, optional): Relational database settings. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.data_source.create(
                ctx, api_id=value, name=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.data_source.create api_id=value, name=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="create_data_source",
        op_kwargs={
            "apiId": api_id,
            "name": name,
            "description": description,
            "type": type_,
            "serviceRoleArn": service_role_arn,
            "dynamodbConfig": dynamodb_config,
            "lambdaConfig": lambda_config,
            "elasticsearchConfig": elasticsearch_config,
            "httpConfig": http_config,
            "relationalDatabaseConfig": relational_database_config,
        },
    )


async def delete(hub, ctx, api_id: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a DataSource object.

    Args:
        api_id(str): The API ID.
        name(str): The name of the data source.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.data_source.delete(ctx, api_id=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.data_source.delete api_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="delete_data_source",
        op_kwargs={"apiId": api_id, "name": name},
    )


async def get(hub, ctx, api_id: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a DataSource object.

    Args:
        api_id(str): The API ID.
        name(str): The name of the data source.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.data_source.get(ctx, api_id=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.data_source.get api_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="get_data_source",
        op_kwargs={"apiId": api_id, "name": name},
    )


async def list_all(
    hub, ctx, api_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the data sources for a given API.

    Args:
        api_id(str): The API ID.
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. . Defaults to None.
        max_results(int, optional): The maximum number of results you want the request to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.data_source.list_all(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.data_source.list_all api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="list_data_sources",
        op_kwargs={"apiId": api_id, "nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    api_id: str,
    name: str,
    type_: str,
    description: str = None,
    service_role_arn: str = None,
    dynamodb_config: Dict = None,
    lambda_config: Dict = None,
    elasticsearch_config: Dict = None,
    http_config: Dict = None,
    relational_database_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a DataSource object.

    Args:
        api_id(str): The API ID.
        name(str): The new name for the data source.
        description(str, optional): The new description for the data source. Defaults to None.
        type_(str): The new data source type.
        service_role_arn(str, optional): The new service role ARN for the data source. Defaults to None.
        dynamodb_config(Dict, optional): The new Amazon DynamoDB configuration. Defaults to None.
        lambda_config(Dict, optional): The new Amazon Web Services Lambda configuration. Defaults to None.
        elasticsearch_config(Dict, optional): The new Elasticsearch Service configuration. Defaults to None.
        http_config(Dict, optional): The new HTTP endpoint configuration. Defaults to None.
        relational_database_config(Dict, optional): The new relational database configuration. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.data_source.update(
                ctx, api_id=value, name=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.data_source.update api_id=value, name=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="update_data_source",
        op_kwargs={
            "apiId": api_id,
            "name": name,
            "description": description,
            "type": type_,
            "serviceRoleArn": service_role_arn,
            "dynamodbConfig": dynamodb_config,
            "lambdaConfig": lambda_config,
            "elasticsearchConfig": elasticsearch_config,
            "httpConfig": http_config,
            "relationalDatabaseConfig": relational_database_config,
        },
    )
