"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, api_id: str, description: str = None, expires: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a unique key that you can distribute to clients who are executing your API.

    Args:
        api_id(str): The ID for your GraphQL API.
        description(str, optional): A description of the purpose of the API key. Defaults to None.
        expires(int, optional): The time from creation time after which the API key expires. The date is represented as seconds since the epoch, rounded down to the nearest hour. The default value for this parameter is 7 days from creation time. For more information, see . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.api.key.create(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.api.key.create api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="create_api_key",
        op_kwargs={"apiId": api_id, "description": description, "expires": expires},
    )


async def delete(hub, ctx, api_id: str, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an API key.

    Args:
        api_id(str): The API ID.
        id_(str): The ID for the API key.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.api.key.delete(ctx, api_id=value, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.api.key.delete api_id=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="delete_api_key",
        op_kwargs={"apiId": api_id, "id": id_},
    )


async def list_all(
    hub, ctx, api_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the API keys for a given API.  API keys are deleted automatically 60 days after they expire. However, they may still be included in the response until they have actually been deleted. You can safely call DeleteApiKey to manually delete a key before it's automatically deleted.

    Args:
        api_id(str): The API ID.
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.
        max_results(int, optional): The maximum number of results you want the request to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.api.key.list_all(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.api.key.list_all api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="list_api_keys",
        op_kwargs={"apiId": api_id, "nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub, ctx, api_id: str, id_: str, description: str = None, expires: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an API key. The key can be updated while it is not deleted.

    Args:
        api_id(str): The ID for the GraphQL API.
        id_(str): The API key ID.
        description(str, optional): A description of the purpose of the API key. Defaults to None.
        expires(int, optional): The time from update time after which the API key expires. The date is represented as seconds since the epoch. For more information, see . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.api.key.update(ctx, api_id=value, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.api.key.update api_id=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="update_api_key",
        op_kwargs={
            "apiId": api_id,
            "id": id_,
            "description": description,
            "expires": expires,
        },
    )
