"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    api_id: str,
    ttl: int,
    api_caching_behavior: str,
    type_: str,
    transit_encryption_enabled: bool = None,
    at_rest_encryption_enabled: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a cache for the GraphQL API.

    Args:
        api_id(str): The GraphQL API Id.
        ttl(int): TTL in seconds for cache entries. Valid values are between 1 and 3600 seconds.
        transit_encryption_enabled(bool, optional): Transit encryption flag when connecting to cache. This setting cannot be updated after creation. Defaults to None.
        at_rest_encryption_enabled(bool, optional): At rest encryption flag for cache. This setting cannot be updated after creation. Defaults to None.
        api_caching_behavior(str): Caching behavior.    FULL_REQUEST_CACHING: All requests are fully cached.    PER_RESOLVER_CACHING: Individual resolvers that you specify are cached.  .
        type_(str): The cache instance type. Valid values are     SMALL     MEDIUM     LARGE     XLARGE     LARGE_2X     LARGE_4X     LARGE_8X (not available in all regions)    LARGE_12X    Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used. The following legacy instance types are available, but their use is discouraged:    T2_SMALL: A t2.small instance type.    T2_MEDIUM: A t2.medium instance type.    R4_LARGE: A r4.large instance type.    R4_XLARGE: A r4.xlarge instance type.    R4_2XLARGE: A r4.2xlarge instance type.    R4_4XLARGE: A r4.4xlarge instance type.    R4_8XLARGE: A r4.8xlarge instance type.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.api.cache.create(
                ctx, api_id=value, ttl=value, api_caching_behavior=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.api.cache.create api_id=value, ttl=value, api_caching_behavior=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="create_api_cache",
        op_kwargs={
            "apiId": api_id,
            "ttl": ttl,
            "transitEncryptionEnabled": transit_encryption_enabled,
            "atRestEncryptionEnabled": at_rest_encryption_enabled,
            "apiCachingBehavior": api_caching_behavior,
            "type": type_,
        },
    )


async def delete(hub, ctx, api_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an ApiCache object.

    Args:
        api_id(str): The API ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.api.cache.delete(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.api.cache.delete api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="delete_api_cache",
        op_kwargs={"apiId": api_id},
    )


async def flush(hub, ctx, api_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Flushes an ApiCache object.

    Args:
        api_id(str): The API ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.api.cache.flush(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.api.cache.flush api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="flush_api_cache",
        op_kwargs={"apiId": api_id},
    )


async def get(hub, ctx, api_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves an ApiCache object.

    Args:
        api_id(str): The API ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.api.cache.get(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.api.cache.get api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="get_api_cache",
        op_kwargs={"apiId": api_id},
    )


async def update(
    hub, ctx, api_id: str, ttl: int, api_caching_behavior: str, type_: str
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the cache for the GraphQL API.

    Args:
        api_id(str): The GraphQL API Id.
        ttl(int): TTL in seconds for cache entries. Valid values are between 1 and 3600 seconds.
        api_caching_behavior(str): Caching behavior.    FULL_REQUEST_CACHING: All requests are fully cached.    PER_RESOLVER_CACHING: Individual resolvers that you specify are cached.  .
        type_(str): The cache instance type. Valid values are     SMALL     MEDIUM     LARGE     XLARGE     LARGE_2X     LARGE_4X     LARGE_8X (not available in all regions)    LARGE_12X    Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used. The following legacy instance types are available, but their use is discouraged:    T2_SMALL: A t2.small instance type.    T2_MEDIUM: A t2.medium instance type.    R4_LARGE: A r4.large instance type.    R4_XLARGE: A r4.xlarge instance type.    R4_2XLARGE: A r4.2xlarge instance type.    R4_4XLARGE: A r4.4xlarge instance type.    R4_8XLARGE: A r4.8xlarge instance type.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appsync.api.cache.update(
                ctx, api_id=value, ttl=value, api_caching_behavior=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appsync.api.cache.update api_id=value, ttl=value, api_caching_behavior=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appsync",
        operation="update_api_cache",
        op_kwargs={
            "apiId": api_id,
            "ttl": ttl,
            "apiCachingBehavior": api_caching_behavior,
            "type": type_,
        },
    )
