"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    stack_name: str = None,
    user_name: str = None,
    authentication_type: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list that describes the UserStackAssociation objects. You must specify either or both of the following:   The stack name   The user name (email address of the user associated with the stack) and the authentication type for the user

    Args:
        stack_name(str, optional): The name of the stack that is associated with the user. Defaults to None.
        user_name(str, optional): The email address of the user who is associated with the stack.  Users' email addresses are case-sensitive. . Defaults to None.
        authentication_type(str, optional): The authentication type for the user who is associated with the stack. You must specify USERPOOL. Defaults to None.
        max_results(int, optional): The maximum size of each page of results. Defaults to None.
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.user.stack_association.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.user.stack_association.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="describe_user_stack_associations",
        op_kwargs={
            "StackName": stack_name,
            "UserName": user_name,
            "AuthenticationType": authentication_type,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
