"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    user_name: str,
    authentication_type: str,
    message_action: str = None,
    first_name: str = None,
    last_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new user in the user pool.

    Args:
        user_name(str): The email address of the user.  Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays. .
        message_action(str, optional): The action to take for the welcome email that is sent to a user after the user is created in the user pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name of the user. If the value is null, the email is sent.   The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords within 7 days, you must send them a new welcome email. . Defaults to None.
        first_name(str, optional): The first name, or given name, of the user. Defaults to None.
        last_name(str, optional): The last name, or surname, of the user. Defaults to None.
        authentication_type(str): The authentication type for the user. You must specify USERPOOL. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.user.init.create(
                ctx, user_name=value, authentication_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.user.init.create user_name=value, authentication_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="create_user",
        op_kwargs={
            "UserName": user_name,
            "MessageAction": message_action,
            "FirstName": first_name,
            "LastName": last_name,
            "AuthenticationType": authentication_type,
        },
    )


async def delete(hub, ctx, user_name: str, authentication_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a user from the user pool.

    Args:
        user_name(str): The email address of the user.  Users' email addresses are case-sensitive. .
        authentication_type(str): The authentication type for the user. You must specify USERPOOL.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.user.init.delete(
                ctx, user_name=value, authentication_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.user.init.delete user_name=value, authentication_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="delete_user",
        op_kwargs={"UserName": user_name, "AuthenticationType": authentication_type},
    )


async def describe_all(
    hub, ctx, authentication_type: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list that describes one or more specified users in the user pool.

    Args:
        authentication_type(str): The authentication type for the users in the user pool to describe. You must specify USERPOOL.
        max_results(int, optional): The maximum size of each page of results. Defaults to None.
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.user.init.describe_all(ctx, authentication_type=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.user.init.describe_all authentication_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="describe_users",
        op_kwargs={
            "AuthenticationType": authentication_type,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def disable(hub, ctx, user_name: str, authentication_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Disables the specified user in the user pool. Users can't sign in to AppStream 2.0 until they are re-enabled. This action does not delete the user.

    Args:
        user_name(str): The email address of the user.  Users' email addresses are case-sensitive. .
        authentication_type(str): The authentication type for the user. You must specify USERPOOL.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.user.init.disable(
                ctx, user_name=value, authentication_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.user.init.disable user_name=value, authentication_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="disable_user",
        op_kwargs={"UserName": user_name, "AuthenticationType": authentication_type},
    )


async def enable(hub, ctx, user_name: str, authentication_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Enables a user in the user pool. After being enabled, users can sign in to AppStream 2.0 and open applications from the stacks to which they are assigned.

    Args:
        user_name(str): The email address of the user.  Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays.  .
        authentication_type(str): The authentication type for the user. You must specify USERPOOL.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.user.init.enable(
                ctx, user_name=value, authentication_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.user.init.enable user_name=value, authentication_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="enable_user",
        op_kwargs={"UserName": user_name, "AuthenticationType": authentication_type},
    )
