"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Creates a usage report subscription. Usage reports are generated daily.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.usage_report_subscription.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.usage_report_subscription.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="create_usage_report_subscription",
        op_kwargs={},
    )


async def delete(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Disables usage report generation.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.usage_report_subscription.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.usage_report_subscription.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="delete_usage_report_subscription",
        op_kwargs={},
    )


async def describe_all(
    hub, ctx, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list that describes one or more usage report subscriptions.

    Args:
        max_results(int, optional): The maximum size of each page of results. Defaults to None.
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.usage_report_subscription.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.usage_report_subscription.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="describe_usage_report_subscriptions",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
