"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    existing_image_name: str,
    new_image_name: str,
    new_image_description: str = None,
    new_image_display_name: str = None,
    new_image_tags: Dict = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new image with the latest Windows operating system updates, driver updates, and AppStream 2.0 agent software. For more information, see the "Update an Image by Using Managed AppStream 2.0 Image Updates" section in Administer Your AppStream 2.0 Images, in the Amazon AppStream 2.0 Administration Guide.

    Args:
        existing_image_name(str): The name of the image to update.
        new_image_name(str): The name of the new image. The name must be unique within the AWS account and Region.
        new_image_description(str, optional): The description to display for the new image. Defaults to None.
        new_image_display_name(str, optional): The name to display for the new image. Defaults to None.
        new_image_tags(Dict, optional): The tags to associate with the new image. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=.  Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters:  _ . : / = + \ - @ If you do not specify a value, the value is set to an empty string. For more information about tags, see Tagging Your Resources in the Amazon AppStream 2.0 Administration Guide. Defaults to None.
        dry_run(bool, optional): Indicates whether to display the status of image update availability before AppStream 2.0 initiates the process of creating a new updated image. If this value is set to true, AppStream 2.0 displays whether image updates are available. If this value is set to false, AppStream 2.0 initiates the process of creating a new updated image without displaying whether image updates are available. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.updated_image.create(
                ctx, existing_image_name=value, new_image_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.updated_image.create existing_image_name=value, new_image_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="create_updated_image",
        op_kwargs={
            "existingImageName": existing_image_name,
            "newImageName": new_image_name,
            "newImageDescription": new_image_description,
            "newImageDisplayName": new_image_display_name,
            "newImageTags": new_image_tags,
            "dryRun": dry_run,
        },
    )
