"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    stack_name: str,
    fleet_name: str,
    user_id: str,
    application_id: str = None,
    validity: int = None,
    session_context: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a temporary URL to start an AppStream 2.0 streaming session for the specified user. A streaming URL enables application streaming to be tested without user setup.

    Args:
        stack_name(str): The name of the stack.
        fleet_name(str): The name of the fleet.
        user_id(str): The identifier of the user.
        application_id(str, optional): The name of the application to launch after the session starts. This is the name that you specified as Name in the Image Assistant. If your fleet is enabled for the Desktop stream view, you can also choose to launch directly to the operating system desktop. To do so, specify Desktop. Defaults to None.
        validity(int, optional): The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 60 seconds. Defaults to None.
        session_context(str, optional): The session context. For more information, see Session Context in the Amazon AppStream 2.0 Administration Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.streaming_url.create(
                ctx, stack_name=value, fleet_name=value, user_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.streaming_url.create stack_name=value, fleet_name=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="create_streaming_url",
        op_kwargs={
            "StackName": stack_name,
            "FleetName": fleet_name,
            "UserId": user_id,
            "ApplicationId": application_id,
            "Validity": validity,
            "SessionContext": session_context,
        },
    )
