"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    description: str = None,
    display_name: str = None,
    storage_connectors: List = None,
    redirect_url: str = None,
    feedback_url: str = None,
    user_settings: List = None,
    application_settings: Dict = None,
    tags: Dict = None,
    access_endpoints: List = None,
    embed_host_domains: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a stack to start streaming applications to users. A stack consists of an associated fleet, user access policies, and storage configurations.

    Args:
        name(str): The name of the stack.
        description(str, optional): The description to display. Defaults to None.
        display_name(str, optional): The stack name to display. Defaults to None.
        storage_connectors(List, optional): The storage connectors to enable. Defaults to None.
        redirect_url(str, optional): The URL that users are redirected to after their streaming session ends. Defaults to None.
        feedback_url(str, optional): The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. Defaults to None.
        user_settings(List, optional): The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. . Defaults to None.
        application_settings(Dict, optional): The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session. Defaults to None.
        tags(Dict, optional): The tags to associate with the stack. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=.  If you do not specify a value, the value is set to an empty string. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters:  _ . : / = + \ - @ For more information about tags, see Tagging Your Resources in the Amazon AppStream 2.0 Administration Guide. Defaults to None.
        access_endpoints(List, optional): The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints. Defaults to None.
        embed_host_domains(List, optional): The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.stack.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.stack.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="create_stack",
        op_kwargs={
            "Name": name,
            "Description": description,
            "DisplayName": display_name,
            "StorageConnectors": storage_connectors,
            "RedirectURL": redirect_url,
            "FeedbackURL": feedback_url,
            "UserSettings": user_settings,
            "ApplicationSettings": application_settings,
            "Tags": tags,
            "AccessEndpoints": access_endpoints,
            "EmbedHostDomains": embed_host_domains,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified stack. After the stack is deleted, the application streaming environment provided by the stack is no longer available to users. Also, any reservations made for application streaming sessions for the stack are released.

    Args:
        name(str): The name of the stack.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.stack.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.stack.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="delete_stack",
        op_kwargs={"Name": name},
    )


async def describe_all(hub, ctx, names: List = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list that describes one or more specified stacks, if the stack names are provided. Otherwise, all stacks in the account are described.

    Args:
        names(List, optional): The names of the stacks to describe. Defaults to None.
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.stack.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.stack.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="describe_stacks",
        op_kwargs={"Names": names, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    name: str,
    display_name: str = None,
    description: str = None,
    storage_connectors: List = None,
    delete_storage_connectors: bool = None,
    redirect_url: str = None,
    feedback_url: str = None,
    attributes_to_delete: List = None,
    user_settings: List = None,
    application_settings: Dict = None,
    access_endpoints: List = None,
    embed_host_domains: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified fields for the specified stack.

    Args:
        display_name(str, optional): The stack name to display. Defaults to None.
        description(str, optional): The description to display. Defaults to None.
        name(str): The name of the stack.
        storage_connectors(List, optional): The storage connectors to enable. Defaults to None.
        delete_storage_connectors(bool, optional): Deletes the storage connectors currently enabled for the stack. Defaults to None.
        redirect_url(str, optional): The URL that users are redirected to after their streaming session ends. Defaults to None.
        feedback_url(str, optional): The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. Defaults to None.
        attributes_to_delete(List, optional): The stack attributes to delete. Defaults to None.
        user_settings(List, optional): The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. Defaults to None.
        application_settings(Dict, optional): The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session. Defaults to None.
        access_endpoints(List, optional): The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints. Defaults to None.
        embed_host_domains(List, optional): The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.stack.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.stack.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="update_stack",
        op_kwargs={
            "DisplayName": display_name,
            "Description": description,
            "Name": name,
            "StorageConnectors": storage_connectors,
            "DeleteStorageConnectors": delete_storage_connectors,
            "RedirectURL": redirect_url,
            "FeedbackURL": feedback_url,
            "AttributesToDelete": attributes_to_delete,
            "UserSettings": user_settings,
            "ApplicationSettings": application_settings,
            "AccessEndpoints": access_endpoints,
            "EmbedHostDomains": embed_host_domains,
        },
    )
