"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    stack_name: str,
    fleet_name: str,
    user_id: str = None,
    next_token: str = None,
    limit: int = None,
    authentication_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list that describes the streaming sessions for a specified stack and fleet. If a UserId is provided for the stack and fleet, only streaming sessions for that user are described. If an authentication type is not provided, the default is to authenticate users using a streaming URL.

    Args:
        stack_name(str): The name of the stack. This value is case-sensitive.
        fleet_name(str): The name of the fleet. This value is case-sensitive.
        user_id(str, optional): The user identifier (ID). If you specify a user ID, you must also specify the authentication type. Defaults to None.
        next_token(str, optional): The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page. Defaults to None.
        limit(int, optional): The size of each page of results. The default value is 20 and the maximum value is 50. Defaults to None.
        authentication_type(str, optional): The authentication method. Specify API for a user authenticated using a streaming URL or SAML for a SAML federated user. The default is to authenticate users using a streaming URL. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.session.describe_all(
                ctx, stack_name=value, fleet_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.session.describe_all stack_name=value, fleet_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="describe_sessions",
        op_kwargs={
            "StackName": stack_name,
            "FleetName": fleet_name,
            "UserId": user_id,
            "NextToken": next_token,
            "Limit": limit,
            "AuthenticationType": authentication_type,
        },
    )


async def expire(hub, ctx, session_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Immediately stops the specified streaming session.

    Args:
        session_id(str): The identifier of the streaming session.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.appstream.session.expire(ctx, session_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.appstream.session.expire session_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="appstream",
        operation="expire_session",
        op_kwargs={"SessionId": session_id},
    )
